
-- need it as a global otherwiser garbage collector will delete its reference...
-- Nicolas Lonard: moved in from px_PhysXPanel.ms
global physXpaneldata = PhysXPanelInterface.instance

global PxGetPhysXPanelTab  -- Forward declaration

struct DebugVisualizerGroup_struct
(
	groupUIName = undefined,	-- localizable name of the group as it is to appear in the UI
	groupRootName = undefined,	-- internal name (alphanumerical characters)
	groupParamMembers = #()		-- array of paramters to be put in this group, automatically computed
)

struct DebugVisualizerParam_struct  -- 
(
	paramRoot = undefined,		-- e.g. "bodyAxis"
	paramDefVal = undefined,	-- value at creation
	paramSDK_name = undefined,	-- e.g. "NX_VISUALIZE_BODY_AXES"
	controlName = undefined,	-- e.g. "Local Axis"
	controlTooltip = undefined,	-- the rollout control tooltip
	controlGroup = undefined	-- the group the control belongs to.  Should match the groupUIName for that group
)

fn initGroupMembers paramGroup paramList =
(
	for noParam = 1 to paramList.count do
	(
		if paramList[noParam].controlGroup == paramGroup.groupRootName then
		(
			append paramGroup.groupParamMembers noParam
		)
	)
)

fn GenerateControlSection groupList paramList =
(
	local ctrlStr = ""
	
	-- Create all controls in the appropriate group
	for noGroup = 1 to groupList.count do
	(
		local nbControlsInGroup = groupList[noGroup].groupParamMembers.count
		if nbControlsInGroup > 0 then
		(
			append ctrlStr "\tgroup \""
			append ctrlStr groupList[noGroup].groupUIName
			append ctrlStr "\"\n"
			append ctrlStr  "\t(\n"
			for noParam = 1 to  nbControlsInGroup do
			(
				-- produce one line per parameter.  It should look like this:
				-- 		checkbox	cb_bodyAxis	"Body Axis"	align:#left offset:[-5, 0]  width:160 checked:true	 tooltip:"Body Axis"
				paramIndex = groupList[noGroup].groupParamMembers[noParam]
				append ctrlStr "\t\tcheckbox\tcb_"
				append ctrlStr paramList[paramIndex].paramRoot
				append ctrlStr "\t\""
				append ctrlStr paramList[paramIndex].controlName
				append ctrlStr "\"\t"
				append ctrlStr "align:#left offset:[-5, 0]  width:160 checked:"
				append ctrlStr (paramList[paramIndex].paramDefVal as string)
				append ctrlStr "\ttooltip:\""
				-- @todo: use paramList[paramIndex].controlTooltip
				append ctrlStr paramList[paramIndex].controlName
				append ctrlStr "\"\n"
			)
			append ctrlStr "\t)\n\n"
		)
	)
	return ctrlStr
)

fn GenerateLoadValuesFn paramList =
(
	local loadValStr = "\tfn loadValues = 
	(
		-- set dialog values from the panel data 
		cb_enableViz.checked = physXpaneldata.visualizerEnable = nvpx.VisualizerGetEnabled()
		sp_scale.value = physXpaneldata.visualizerScale = nvpx.VisualizerGetScale()\n"
	
	for noParam = 1 to paramList.count do
	(
		-- generate a line similar to
		-- cb_bodyAxis.checked = physXpaneldata.bodyAxis = (nvpx.getSDKParameter "NX_VISUALIZE_BODY_AXES" != 0.0)
		append loadValStr "\t\tcb_"
		append loadValStr paramList[noParam].paramRoot
		append loadValStr ".checked = physXpaneldata."
		append loadValStr paramList[noParam].paramRoot
		append loadValStr " = (nvpx.getSDKParameter \""
		append loadValStr paramList[noParam].paramSDK_name
		append loadValStr "\" != 0.0)\n"
	)
	append loadValStr "\t)\n\n"
	return loadValStr
)

fn GenerateSaveValuesFn paramList =
(
	local saveValStr = "\tfn saveValues = 
	(
		-- save dialog values to the SDK and to the panel data
		nvpx.VisualizerSetEnabled (physXpaneldata.visualizerEnable = cb_enableViz.checked)
		nvpx.VisualizerSetScale (physXpaneldata.visualizerScale = sp_scale.value)\n\n"
	
	for noParam = 1 to paramList.count do
	(
		-- generate a line similar to:
		-- physXpaneldata.bodyAxis = cb_bodyAxis.checked
		append saveValStr "\t\tphysXpaneldata."
		append saveValStr paramList[noParam].paramRoot
		append saveValStr " = cb_"
		append saveValStr paramList[noParam].paramRoot
		append saveValStr ".checked\n"
	)
	append saveValStr "\t)\n\n"
	return saveValStr
)

fn GenerateControlChangedFn paramList =
(
	local changedFnStr = ""
	-- *****************************************************************************************
	-- for each parameter add a function that sets the SDK values and combo box from the panel data
	-- *****************************************************************************************
	for noParam = 1 to paramList.count do
	(
		append changedFnStr "\tfn "
		append changedFnStr paramList[noParam].paramRoot
		append changedFnStr "Changed =\n\t(\n\t\tcb_"
		append changedFnStr paramList[noParam].paramRoot
		append changedFnStr ".checked = physXpaneldata."
		append changedFnStr paramList[noParam].paramRoot
		append changedFnStr "\n\t)\n"
	)
	return changedFnStr
)

fn GenerateGroupChangedFunctions groupList paramList =
(
	local changedFnStr = "\tfn optionsChanged = \n\t(
		nvpx.VisualizerSetEnabled (cb_enableViz.checked = physXpaneldata.visualizerEnable)
		nvpx.VisualizerSetScale (sp_scale.value = physXpaneldata.visualizerScale)
	)\n\n"

	for noGroup = 1 to groupList.count do
	(
		local nbControlsInGroup = groupList[noGroup].groupParamMembers.count
		if nbControlsInGroup > 0 then
		(
			append changedFnStr "\tfn "
			append changedFnStr groupList[noGroup].groupRootName
			append changedFnStr "Changed =\n\t(\n"
			for noParam = 1 to  nbControlsInGroup do
			(
				local paramIndex = groupList[noGroup].groupParamMembers[noParam]
				append changedFnStr "\t\t"
				append changedFnStr paramList[paramIndex].paramRoot
				append changedFnStr "Changed()\n"
			)
			append changedFnStr "\t\tRedrawViews()\n\t)\n\n"
		)
	)
	return changedFnStr
)

fn GenerateControlEventHandler paramList =
(
	local handlerStr = ""
	for noParam = 1 to paramList.count do
	(
		append handlerStr "\ton cb_"
		append handlerStr paramList[noParam].paramRoot
		append handlerStr " changed value do\n\t(\n\t\tundo \"PhysX Visualizer "
		append handlerStr paramList[noParam].controlGroup
		append handlerStr " edit\" on\n\t\t(\n\t\t\tphysXpaneldata."
		append handlerStr paramList[noParam].paramRoot
		append handlerStr " = value\n\t\t)\n\t\t"
		append handlerStr paramList[noParam].paramRoot
		append handlerStr "Changed()\n\t)\n"
	)
	return handlerStr
)

fn GenerateFullRolloutString groupList paramList =
(
	local rolloutName = nvpx.GetPluginCompanyName() + nvpxText.UI_PANEL_VISUALIZE_ROLLOUT_VISUALIZE_SUFFIX

	local rolloutStr = "rollout px_panel_debugVisualizer \"" + rolloutName + "\" rolledUp:false
(
	group \"Options\"
	(
		checkbox		cb_enableViz	\"Enable Visualizer\"	align:#left  checked:false
		label			lb_scale	\"Scale\"	 align:#left across:2
		spinner         sp_scale	align:#right width:65 range:[0, PxMaxValue, 5]
	)\n\n"

	append rolloutStr (GenerateControlSection groupList paramList)

	-- Add function loadValues()/saveValues()
	append rolloutStr (GenerateLoadValuesFn paramList)
	append rolloutStr (GenerateSaveValuesFn paramList)
	
	-- Add control and group property changed functions
	append rolloutStr (GenerateControlChangedFn paramList)
	append rolloutStr (GenerateGroupChangedFunctions groupList paramList)

	
	-- *****************************************************************************************
	-- Event handlers
	-- *****************************************************************************************
	append rolloutStr "

	fn IsVisible =
	(
		(PxGetPhysXPanelTab()) == PxTabIndexDisplay
	)
		
	on px_panel_debugVisualizer open do
	(
		loadValues()
        -- setup localized group name
        px_panel_debugVisualizer.controls[1].text = nvpxText.displayPanelVisualizerOptions
		px_panel_debugVisualizer.cb_enableViz.text = nvpxText.UI_PANEL_VISUALIZE_ENABLE
		px_panel_debugVisualizer.lb_scale.text = nvpxText.UI_PANEL_VISUALIZE_SCALE
		px_panel_debugVisualizer.sp_scale.tooltip = nvpxText.UI_PANEL_VISUALIZE_SCALE_TOOLTIP
	)
	
	on px_panel_debugVisualizer close do
	(
		saveValues()
	)
	
	on cb_enableViz changed value do
	(
		undo \"PhysX Visualizer Enable edit\" on
		(
			TurnOnMacroRecorderContext true
			physXpaneldata.visualizerEnable = value
			TurnOnMacroRecorderContext false
		)
		nvpx.VisualizerSetEnabled value
	)
	
	on sp_scale changed value do
	(
		undo \"PhysX Visualizer Scale edit\" on
		(
			TurnOnMacroRecorderContext true
			physXpaneldata.visualizerScale = value
			TurnOnMacroRecorderContext false
		)
		nvpx.VisualizerSetScale value
	)
	
	on px_panel_debugVisualizer help do( HelpSystem.ShowProductHelp 15013 )\n\n"
	
	append rolloutStr (GenerateControlEventHandler paramList)

	-- Final closing parenthesis for rollout
	append rolloutStr ")\n"
	return rolloutStr
)

fn GenerateUndoFunction groupList =
(
	local undoFnStr = "fn pxDebugVisualizerUndo =
(
	local t = callbacks.notificationParam()\n"
	
	local firstGroup = true
	for noGroup = 1 to groupList.count do (
		local nbControlsInGroup = groupList[noGroup].groupParamMembers.count
		if nbControlsInGroup > 0 then
		(
			append undoFnStr "\t"
			if (not firstGroup) then
				append undoFnStr "else "
			append undoFnStr "if t == \"PhysX Visualizer "
			append undoFnStr groupList[noGroup].groupUIName
			append undoFnStr " edit\" then (\n\t\tpx_panel_debugVisualizer."
			append undoFnStr groupList[noGroup].groupRootName
			append undoFnStr "Changed()\n\t)\n"
			firstGroup = false
		)
	)
	append undoFnStr ")\n\n"
	return undoFnStr
)

fn debugVisualizerAutoUI = 
(
	local debugVisualizerGroups = #(
		(DebugVisualizerGroup_struct	groupUIName:nvpxText.UI_PANEL_VISUALIZE_GRP_OBJECT_PROPERTIES	groupRootName:"objectProperties"),
		(DebugVisualizerGroup_struct	groupUIName:nvpxText.UI_PANEL_VISUALIZE_GRP_JOINT_PROPERTIES	groupRootName:"jointProperties"),
		(DebugVisualizerGroup_struct	groupUIName:nvpxText.UI_PANEL_VISUALIZE_GRP_CONTACT_MARKERS	groupRootName:"contactProperties"),
		(DebugVisualizerGroup_struct	groupUIName:nvpxText.UI_PANEL_VISUALIZE_GRP_COLLISION_MARKERS	groupRootName:"collisionProperties")
	)

	local debugVisualizerList = #(
		(DebugVisualizerParam_struct	paramRoot:"bodyAxis"		paramDefVal:true	paramSDK_name:"NX_VISUALIZE_BODY_AXES"  		controlName:nvpxText.UI_PANEL_VISUALIZE_BODY_AXES			controlGroup:"objectProperties"),
		(DebugVisualizerParam_struct	paramRoot:"bodyLinearVel"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_BODY_LIN_VELOCITY"  controlName:nvpxText.UI_PANEL_VISUALIZE_BODY_LIN_VELOCITY	controlGroup:"objectProperties"),
		(DebugVisualizerParam_struct	paramRoot:"bodyAngularVel"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_BODY_ANG_VELOCITY"  controlName:nvpxText.UI_PANEL_VISUALIZE_BODY_ANG_VELOCITY	controlGroup:"objectProperties"),

		(DebugVisualizerParam_struct	paramRoot:"jointLocalAxis"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_JOINT_LOCAL_AXES"	controlName:nvpxText.UI_PANEL_VISUALIZE_JOINT_LOCAL_AXES	controlGroup:"jointProperties"),
		(DebugVisualizerParam_struct	paramRoot:"jointWorldAxis"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_JOINT_WORLD_AXES"	controlName:nvpxText.UI_PANEL_VISUALIZE_JOINT_WORLD_AXES	controlGroup:"jointProperties"),
		(DebugVisualizerParam_struct	paramRoot:"jointLimits"		paramDefVal:false	paramSDK_name:"NX_VISUALIZE_JOINT_LIMITS"		controlName:nvpxText.UI_PANEL_VISUALIZE_JOINT_LIMITS		controlGroup:"jointProperties"),

		(DebugVisualizerParam_struct	paramRoot:"contactPoints"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_CONTACT_POINT"		controlName:nvpxText.UI_PANEL_VISUALIZE_CONTACT_POINT	controlGroup:"contactProperties"),
		(DebugVisualizerParam_struct	paramRoot:"contactNormal"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_CONTACT_NORMAL"		controlName:nvpxText.UI_PANEL_VISUALIZE_CONTACT_NORMAL	controlGroup:"contactProperties"),
		(DebugVisualizerParam_struct	paramRoot:"contactForce"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_CONTACT_FORCE"		controlName:nvpxText.UI_PANEL_VISUALIZE_CONTACT_FORCE		controlGroup:"contactProperties"),

		(DebugVisualizerParam_struct	paramRoot:"collisionShapes"		paramDefVal:true	paramSDK_name:"NX_VISUALIZE_COLLISION_SHAPES"	controlName:nvpxText.UI_PANEL_VISUALIZE_COLLISION_SHAPES	controlGroup:"collisionProperties"),
		(DebugVisualizerParam_struct	paramRoot:"collisionCompounds"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_COLLISION_COMPOUNDS" controlName:nvpxText.UI_PANEL_VISUALIZE_COLLISION_COMPOUNDS	controlGroup:"collisionProperties"),
		(DebugVisualizerParam_struct	paramRoot:"collisionSpheres"	paramDefVal:false	paramSDK_name:"NX_VISUALIZE_COLLISION_SPHERES"	controlName:nvpxText.UI_PANEL_VISUALIZE_COLLISION_SPHERES	controlGroup:"collisionProperties")
	)

	-- put each parameter into the groupParamMembers of the group it belongs to.
	-- This has to be done before we generate the rollout 
	for noGroup = 1 to debugVisualizerGroups.count do (
		initGroupMembers debugVisualizerGroups[noGroup] debugVisualizerList
	)

	local rolloutStr = GenerateFullRolloutString debugVisualizerGroups debugVisualizerList
	execute rolloutStr
	
	-- Generate pxDebugVisualizerUndo(), an undo function that can handle this rollout's events
	local undoStr = GenerateUndoFunction debugVisualizerGroups
	execute undoStr
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBigOEkogFrUpiIraUJRfgy0VK9ZXehS34R
-- eyx65mF5iC4QwSmtN26QZue7E2oM+BwQGesniBzWewWvCALc1BAcesc0K6KKwOUO
-- 03fDt8w3wTH8c4d/dFnR/+3OlG/hNoBvae/cdemDupDIKt4Z5Yxokb4Iyk4mUioe
-- MrXAEh4T/thbijIb961XK0PM/aGLEnW/m/wBulfSAol0VTFL8q9n3He1Dc1+IhWx
-- VLkZxa3pCtb3v//CX+Dz6GeTWo+oDgcZ3NUtn/83B5c7NDnp8lZ72mntlnL1W+8e
-- ZHvAbOLRMuSS9PC7TQNLL77dwkrieoCLm8HUav3yyREOOWHEjPA+
-- -----END-SIGNATURE-----